//=============================================================================
// Credits.
//=============================================================================
class RandomMoneys extends DeusExPickup;

var() int numCredits;
var localized String msgCreditsAdded;

#exec MESH IMPORT MESH=Money ANIVFILE=MODELS\Moneys_a.3d DATAFILE=MODELS\Moneys_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Money X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=Money SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Money SEQ=Money STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=Money MESH=Money
#exec MESHMAP SCALE MESHMAP=Money X=0.01933655625 Y=0.01933655625 Z=0.01933655625

#exec TEXTURE IMPORT FILE="Textures\MoneyGreen.pcx"	NAME="MoneyGreen"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\MoneyDGreen.pcx"	NAME="MoneyDGreen"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\MoneyYellow.pcx"	NAME="MoneyYellow"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=Money NUM=0 TEXTURE=MoneyGreen
#exec MESHMAP SETTEXTURE MESHMAP=Money NUM=1 TEXTURE=MoneyDGreen
#exec MESHMAP SETTEXTURE MESHMAP=Money NUM=2 TEXTURE=MoneyYellow


function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 numCredits = Rand(78) + 1;
 
 ItemName = "|p4"$numCredits$" Dollar(s)";
}

// ----------------------------------------------------------------------
// Frob()
//
// Add these credits to the player's credits count
// ----------------------------------------------------------------------
auto state Pickup
{
	function Frob(Actor Frobber, Inventory frobWith)
	{
		local DeusExPlayer player;

		Super.Frob(Frobber, frobWith);

		player = DeusExPlayer(Frobber);

		if (player != None)
		{
			player.Credits += numCredits;
			//player.ClientMessage(Sprintf(msgCreditsAdded, numCredits));
			player.FrobTarget = None;
			Destroy();
		}
	}
}

defaultproperties
{
     numCredits=100
     msgCreditsAdded="You found %d dollar(s)."
     ItemName="ERROR"
     ItemArticle=""
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'Money'
     PickupViewMesh=LodMesh'Money'
     ThirdPersonMesh=LodMesh'Money'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit1'
     Icon=Texture'DeusExUI.Icons.BeltIconCredits'
     beltDescription="ERROR"
     Mesh=LodMesh'Money'
     CollisionRadius=4.500000
     CollisionHeight=1.500000
     Mass=2.000000
     Buoyancy=3.000000
     InvSlotsX=0
     InvSlotsY=0
}
